#include "stdafx.h"
#include "tcpip.h"
#include "string.h"
#include <windows.h>

TCPIP::TCPIP(int portnumber)
{
	port=portnumber;
	connect=false;
	quit=false;
	openConnection();
  DWORD dwThreadID;
  HANDLE hAcceptThread = CreateThread (NULL, 0, AcceptThread, (LPVOID) this, 0, 
                                  &dwThreadID);
  if (hAcceptThread)
	{
      CloseHandle (hAcceptThread);
	}
    else
	{
		MessageBox (0, TEXT("Unable to create the tcpip accept thread"), 
                TEXT("Error"), MB_OK);
	}

}
 
bool TCPIP::openConnection()
{

	TCHAR szError[100];                 // Error message string
	WSADATA WSAData;						// Contains details of the Winsock
										// implementation
	SOCKADDR_IN local_sin;              // Local socket address

  // Initialize Winsock.
  if (WSAStartup (MAKEWORD(1,1), &WSAData) != 0) 
  {
    wsprintf (szError, TEXT("WSAStartup failed. Error: %d"), 
              WSAGetLastError ());
    MessageBox (NULL, szError, TEXT("Error"), MB_OK);
    return FALSE;
  }

  // Create a TCP/IP socket, WinSocket.
  if ((listensock = socket (AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET) 
  {
    wsprintf (szError, TEXT("Allocating socket failed. Error: %d"), 
              WSAGetLastError ());
    MessageBox (NULL, szError, TEXT("Error"), MB_OK);
    return FALSE;
  } 

  // Fill out the local socket's address information.
  local_sin.sin_family = AF_INET;
  local_sin.sin_port = htons (port);  
  local_sin.sin_addr.s_addr = htonl (INADDR_ANY);

  // Associate the local address with WinSocket.
  if (bind (listensock, 
            (struct sockaddr *) &local_sin, 
            sizeof (local_sin)) == SOCKET_ERROR) 
  {
    wsprintf (szError, TEXT("Binding socket failed. Error: %d"), 
              WSAGetLastError ());
    MessageBox (NULL, szError, TEXT("Error"), MB_OK);
    closesocket (listensock);
    return FALSE;
  } 
  // Establish a socket to listen for incoming connections.
  if (listen (listensock, MAX_PENDING_CONNECTS) == SOCKET_ERROR) 
  {
    wsprintf (szError, 
              TEXT("Listening to the client failed. Error: %d"),
              WSAGetLastError ());
    MessageBox (NULL, szError, TEXT("Error"), MB_OK);
    closesocket (listensock);
    return FALSE;
  }

  return TRUE;
}

DWORD AcceptThread(LPVOID tcpip)
{
  TCPIP *t=(TCPIP*)tcpip;
  while(!t->quit) {
	Sleep(500);
	if(!t->connect) {
	  t->acceptSocket();
	  t->connect=true;	
	}
  }
  return 0;
}

//accepts a connection and moves it over to ClientSock
bool TCPIP::acceptSocket()
{
  int accept_sin_len;                 // Length of accept_sin
  SOCKADDR_IN accept_sin;             // Receives the address of the connecting entity
  TCHAR szError[100];                 // Error message string

  accept_sin_len = sizeof (accept_sin);	

  // Accept an incoming connection attempt on WinSocket.
  sock = accept (listensock, 
                       (struct sockaddr *) &accept_sin, 
                       (int *) &accept_sin_len);
  if (sock == INVALID_SOCKET) 
  {
    wsprintf (szError, TEXT("Accepting connection with client failed.")
              TEXT(" Error: %d"), WSAGetLastError ());
    MessageBox (NULL, szError, TEXT("Error"), MB_OK);
    return FALSE;
  } 
  return TRUE;
}


//data recieved
//returns the number of characters recieved (-1 is the error code)
//echo if true echos anything recieved back to the client
//data is a pointer to where the data is at
//client sock is the socket to recieve from that is already accepted
int TCPIP::recieveData(char*& data)
{
	if(!connected()) {
		return -1;
	}
	int iReturn;
	data=&(recievedData[0]);

	for(int i=0; i<1000; i++) {
		recievedData[i]=0;
	}
    // Receive data from the client.
    iReturn = recv (sock, recievedData, sizeof (recievedData), 0);

    // Check if there is any data received. If there is, display it.
    if (iReturn == SOCKET_ERROR) {
      return -1;
    } else if (iReturn == 0) {
	   //we are no longer connected
		connect=false;
       return -1;
    } else {
		int length=-1;
		//find out how long the string is
		for(int i=0; i<1000; i++) {
			if(recievedData[i]!=0) {
				length=i;
			}
		}
		length++;	
		return length;
    }
}


bool TCPIP::sendData(char* data)
{
	if(!connected()) {
		return false;
	}
	int length=strlen(data);
	send (sock, data, length , 0);	
	return true;
}

bool TCPIP::sendData2(char* data, int length)
{
	if(!connected()) {
		return false;
	}
	send (sock, data, length , 0);	
	return true;
}


//close the tcp/ip connection
void TCPIP::closeConnection()
{
  quit=true;
  connect=false;
  closesocket (sock);
  WSACleanup ();
}
